/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiDataSend;
import noppes.npcs.client.gui.SubGuiEditText;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.Marcet;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNpcManagePlayerData
extends GuiNPCInterface2
implements ISubGuiListener,
IScrollData,
ICustomScrollListener,
GuiYesNoCallback,
IGuiData,
ITextfieldListener {
    public HashMap<String, Integer> data = new HashMap();
    public HashMap<String, String> scrollData = new HashMap();
    private boolean isOnline = false;
    private GuiCustomScroll scroll;
    public String search = "";
    public String selected = null;
    public String selectedPlayer = null;
    public EnumPlayerData selection = EnumPlayerData.Players;
    private NBTTagCompound gameData = null;

    public GuiNpcManagePlayerData(EntityNPCInterface npc) {
        super(npc);
        Client.sendData(EnumPacketServer.PlayerDataGet, new Object[]{this.selection});
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        int id = button.getID();
        GuiNpcTextField.unfocus();
        String title = this.selectedPlayer;
        switch (this.selection) {
            case Quest: {
                title = new TextComponentTranslation("quest.quest", new Object[0]).func_150254_d();
                break;
            }
            case Dialog: {
                title = new TextComponentTranslation("dialog.dialog", new Object[0]).func_150254_d();
                break;
            }
            case Transport: {
                title = new TextComponentTranslation("global.transport", new Object[0]).func_150254_d();
                break;
            }
            case Bank: {
                title = new TextComponentTranslation("global.banks", new Object[0]).func_150254_d();
                break;
            }
            case Factions: {
                title = new TextComponentTranslation("menu.factions", new Object[0]).func_150254_d();
                break;
            }
            case Game: {
                title = new TextComponentTranslation("gui.game", new Object[0]).func_150254_d();
                break;
            }
        }
        if (id == 0) {
            if (this.selection == EnumPlayerData.Players || !this.scroll.hasSelected()) {
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("global.playerdata", new Object[0]).func_150254_d() + ": " + title, new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 0);
                this.displayGuiScreen((GuiScreen)guiyesno);
            } else {
                Client.sendData(EnumPacketServer.PlayerDataSet, this.selection.ordinal(), this.selectedPlayer, 1, this.data.get(this.scrollData.get(this.scroll.getSelected())));
            }
        } else if (id >= 1 && id <= 6 || id == 9) {
            if (this.selectedPlayer == null && id != 1) {
                return;
            }
            if (this.selection == EnumPlayerData.Game) {
                this.save();
            }
            this.selection = id == 9 ? EnumPlayerData.Game : EnumPlayerData.values()[id - 1];
            this.initButtons();
            this.scroll.clear();
            this.data.clear();
            Client.sendData(EnumPacketServer.PlayerDataGet, new Object[]{this.selection, this.selectedPlayer});
            this.selected = null;
            this.getTextField(0).setFullText("");
        } else if (id == 7) {
            GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("gui.wipe", new Object[0]).func_150254_d() + "?", new TextComponentTranslation("data.hover.wipe", new Object[0]).func_150254_d().replace("<br>", "\n"), 7);
            this.displayGuiScreen((GuiScreen)guiyesno);
        } else if (id == 12) {
            GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("gui.cleaning", new Object[0]).func_150254_d() + "?", new TextComponentTranslation("data.hover.cleaning", new Object[0]).func_150254_d().replace("<br>", "\n"), 12);
            this.displayGuiScreen((GuiScreen)guiyesno);
        } else if (id == 8) {
            SubGuiEditText subgui = new SubGuiEditText(0, "");
            subgui.label = "gui.add";
            switch (this.selection) {
                case Quest: {
                    subgui.hovers[0] = "";
                    for (int i : QuestController.instance.quests.keySet()) {
                        if (this.data.containsValue(i)) continue;
                        if (!subgui.hovers[0].isEmpty()) {
                            subgui.hovers[0] = subgui.hovers[0] + ", ";
                        }
                        subgui.hovers[0] = subgui.hovers[0] + i;
                    }
                    subgui.hovers[0] = new TextComponentTranslation("gui.options", new Object[0]).func_150254_d() + " ID:<br>" + subgui.hovers[0];
                    break;
                }
                case Dialog: {
                    subgui.hovers[0] = "";
                    for (int i : DialogController.instance.dialogs.keySet()) {
                        if (this.data.containsValue(i)) continue;
                        if (!subgui.hovers[0].isEmpty()) {
                            subgui.hovers[0] = subgui.hovers[0] + ", ";
                        }
                        subgui.hovers[0] = subgui.hovers[0] + i;
                    }
                    subgui.hovers[0] = new TextComponentTranslation("gui.options", new Object[0]).func_150254_d() + " ID:<br>" + subgui.hovers[0];
                    break;
                }
                case Transport: {
                    break;
                }
                case Bank: {
                    subgui.hovers[0] = "";
                    for (int i : BankController.getInstance().banks.keySet()) {
                        if (this.data.containsValue(i)) continue;
                        if (!subgui.hovers[0].isEmpty()) {
                            subgui.hovers[0] = subgui.hovers[0] + ", ";
                        }
                        subgui.hovers[0] = subgui.hovers[0] + i;
                    }
                    subgui.hovers[0] = new TextComponentTranslation("gui.options", new Object[0]).func_150254_d() + " ID:<br>" + subgui.hovers[0];
                    break;
                }
                case Factions: {
                    subgui.hovers[0] = "";
                    for (int i : FactionController.instance.factions.keySet()) {
                        if (this.data.containsValue(i)) continue;
                        if (!subgui.hovers[0].isEmpty()) {
                            subgui.hovers[0] = subgui.hovers[0] + ", ";
                        }
                        subgui.hovers[0] = subgui.hovers[0] + i;
                    }
                    subgui.hovers[0] = new TextComponentTranslation("gui.options", new Object[0]).func_150254_d() + " ID:<br>" + '\u00a7' + "6" + subgui.hovers[0];
                    break;
                }
                default: {
                    return;
                }
            }
            this.setSubGui(subgui);
        } else if (id == 10) {
            GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("global.playerdata", new Object[0]).func_150254_d() + ": " + title, new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 1);
            this.displayGuiScreen((GuiScreen)guiyesno);
        } else if (id == 11) {
            this.editData();
        }
    }

    public void func_73878_a(boolean result, int id) {
        String sel = this.selected;
        String playerName = this.selectedPlayer;
        EnumPlayerData epd = this.selection;
        NoppesUtil.openGUI((EntityPlayer)this.player, this);
        this.selected = sel;
        this.selectedPlayer = playerName;
        this.selection = epd;
        if (!result) {
            return;
        }
        if (id == 0) {
            if (this.selection != EnumPlayerData.Players) {
                return;
            }
            this.data.clear();
            Client.sendData(EnumPacketServer.PlayerDataRemove, new Object[]{this.selection, this.selectedPlayer, this.selected});
            this.selected = null;
            this.selectedPlayer = null;
            this.scroll.setSelect(-1);
            this.initButtons();
        } else if (id == 1) {
            Client.sendData(EnumPacketServer.PlayerDataSet, this.selection.ordinal(), this.selectedPlayer, 3, -1);
        } else if (id == 7) {
            this.selection = EnumPlayerData.Wipe;
            this.initButtons();
            this.scroll.clear();
            this.data.clear();
            Client.sendData(EnumPacketServer.PlayerDataRemove, new Object[]{this.selection, this.selectedPlayer, this.selected});
            this.selected = null;
            this.selectedPlayer = null;
            this.scroll.setSelect(-1);
        } else if (id == 12) {
            SubGuiDataSend subgui = new SubGuiDataSend(0);
            this.setSubGui(subgui);
        }
    }

    private void editData() {
        if (!this.scroll.hasSelected()) {
            return;
        }
        switch (this.selection) {
            case Bank: {
                Client.sendData(EnumPacketServer.BankShow, new Object[]{this.selection, this.selectedPlayer, this.data.get(this.scrollData.get(this.scroll.getSelected()))});
                break;
            }
            case Factions: {
                int factionId = this.data.get(this.scrollData.get(this.scroll.getSelected()));
                SubGuiEditText subgui = new SubGuiEditText(1, "");
                Faction f = FactionController.instance.factions.get(factionId);
                String v = this.scroll.getHoversTexts().get(this.scroll.getSelect()).get(0);
                int value = -1;
                try {
                    value = Integer.parseInt(v.substring(v.indexOf("\u00a73") + 2));
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
                subgui.numbersOnly = f != null ? new int[]{0, f.friendlyPoints * 2, value} : new int[]{0, Integer.MAX_VALUE, value};
                subgui.text[0] = "" + value;
                subgui.label = "gui.set.new.value";
                this.setSubGui(subgui);
                break;
            }
            case Game: {
                if (this.gameData == null || !this.data.containsKey(this.scroll.getSelected())) {
                    return;
                }
                SubGuiEditText subgui = new SubGuiEditText(2, "");
                subgui.func_73866_w_();
                subgui.getTextField(0).setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, 0L);
                int m = 3;
                int s = 0;
                int id = this.data.get(this.scroll.getSelected());
                MarcetController mData = MarcetController.getInstance();
                for (int i = 0; i < this.gameData.func_74775_l("GameData").func_150295_c("MarketData", 10).func_74745_c(); ++i) {
                    NBTTagCompound nbt = this.gameData.func_74775_l("GameData").func_150295_c("MarketData", 10).func_150305_b(i);
                    if (id != nbt.func_74762_e("MarketID")) continue;
                    s = nbt.func_74762_e("Slot");
                    Marcet marcet = (Marcet)mData.getMarcet(id);
                    if (marcet == null) break;
                    m = marcet.markup.size() - 1;
                    break;
                }
                subgui.text[0] = "" + s;
                subgui.getTextField(0).setMinMaxDefault(0L, m, s);
                subgui.label = "gui.set.new.value";
                this.setSubGui(subgui);
            }
        }
    }

    public void initButtons() {
        boolean hasPlayer = this.selectedPlayer != null && !this.selectedPlayer.isEmpty();
        this.getButton(0).setIsVisible(true);
        this.getButton(0).setEnabled(hasPlayer);
        this.getButton(1).setEnabled(this.selection != EnumPlayerData.Players && hasPlayer);
        this.getButton(2).setEnabled(this.selection != EnumPlayerData.Quest && hasPlayer);
        this.getButton(3).setEnabled(this.selection != EnumPlayerData.Dialog && hasPlayer);
        this.getButton(4).setEnabled(this.selection != EnumPlayerData.Transport && hasPlayer);
        this.getButton(5).setEnabled(this.selection != EnumPlayerData.Bank && hasPlayer);
        this.getButton(6).setEnabled(this.selection != EnumPlayerData.Factions && hasPlayer);
        this.getButton(9).setEnabled(this.selection != EnumPlayerData.Game && hasPlayer);
        boolean canEdit = this.selection != EnumPlayerData.Players && this.selection != EnumPlayerData.Wipe;
        this.getButton(8).setIsVisible(true);
        this.getButton(10).setIsVisible(true);
        this.getButton(11).setIsVisible(true);
        this.getButton(12).setEnabled(this.selection == EnumPlayerData.Players);
        if (this.scroll != null) {
            if (this.selection != EnumPlayerData.Game) {
                this.scroll.guiLeft = this.guiLeft + 7;
                this.scroll.guiTop = this.guiTop + 16;
                this.scroll.setSize(300, 152);
            } else {
                this.scroll.guiLeft = this.guiLeft + 7;
                this.scroll.guiTop = this.guiTop + 52;
                this.scroll.setSize(120, 138);
            }
        }
        this.getLabel(1).setEnabled(this.selection != EnumPlayerData.Game);
        this.getTextField(0).setIsVisible(this.selection != EnumPlayerData.Game);
        if (this.getLabel(2) != null) {
            this.getLabel(2).setEnabled(this.selection == EnumPlayerData.Game);
        }
        if (this.getLabel(3) != null) {
            this.getLabel(3).setEnabled(this.selection == EnumPlayerData.Game);
        }
        if (this.getTextField(1) != null) {
            this.getTextField(1).setIsVisible(this.selection == EnumPlayerData.Game);
        }
        switch (this.selection) {
            case Quest: 
            case Dialog: 
            case Transport: {
                this.getButton(8).setEnabled(canEdit && hasPlayer);
                this.getButton(10).setEnabled(canEdit && hasPlayer && !this.scroll.getList().isEmpty());
                this.getButton(11).setEnabled(false);
                break;
            }
            case Bank: {
                this.getButton(8).setEnabled(canEdit && hasPlayer && this.data.size() < BankController.getInstance().banks.size());
                this.getButton(10).setEnabled(canEdit && hasPlayer && !this.scroll.getList().isEmpty());
                this.getButton(11).setEnabled(canEdit && hasPlayer && this.scroll != null && this.scroll.hasSelected());
                break;
            }
            case Factions: {
                this.getButton(8).setEnabled(canEdit && hasPlayer && this.data.size() < FactionController.instance.factions.size());
                this.getButton(10).setEnabled(canEdit && hasPlayer && !this.scroll.getList().isEmpty());
                this.getButton(11).setEnabled(canEdit && hasPlayer && this.scroll != null && this.scroll.hasSelected());
                break;
            }
            case Game: {
                this.getButton(0).setEnabled(canEdit && hasPlayer && this.scroll.hasSelected());
                this.getButton(8).setIsVisible(false);
                this.getButton(10).setEnabled(canEdit && hasPlayer && this.gameData != null);
                this.getButton(11).setEnabled(canEdit && hasPlayer && this.scroll.hasSelected());
                break;
            }
            default: {
                this.getButton(8).setIsVisible(false);
                this.getButton(10).setIsVisible(false);
                this.getButton(11).setIsVisible(false);
            }
        }
        if (!hasPlayer) {
            this.getLabel(0).setLabel(new TextComponentTranslation("data.all.players", new Object[0]).func_150254_d() + " (" + (this.scroll.getList() == null ? "1" : Integer.valueOf(this.scroll.getList().size())) + ")");
        } else {
            this.getLabel(0).setLabel(new TextComponentTranslation("data.sel.player", new Object[]{'\u00a7' + (this.isOnline ? "2" : "4") + '\u00a7' + "l" + this.selectedPlayer}).func_150254_d() + '\u00a7' + "r (" + (this.scroll.getList() == null ? "1" : Integer.valueOf(this.scroll.getList().size())) + ")");
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(300, 152);
        }
        this.scroll.guiLeft = this.guiLeft + 7;
        this.scroll.guiTop = this.guiTop + 16;
        this.addScroll(this.scroll);
        this.selected = null;
        this.addLabel(new GuiNpcLabel(0, "data.all.players", this.guiLeft + 10, this.guiTop + 6));
        int x = this.guiLeft + 313;
        int y = this.guiTop + 16;
        int w = 99;
        GuiNpcButton button = new GuiNpcButton(1, x, y, w, 20, "playerdata.players");
        button.setHoverText("data.hover.list", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, x, y += 22, w, 20, "quest.quest");
        button.setHoverText("data.hover.quests", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, x, y += 22, w, 20, "dialog.dialog");
        button.setHoverText("data.hover.dialogs", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(4, x, y += 22, w, 20, "global.transport");
        button.setHoverText("data.hover.transports", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(5, x, y += 22, w, 20, "global.banks");
        button.setHoverText("data.hover.banks", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(6, x, y += 22, w, 20, "menu.factions");
        button.setHoverText("data.hover.factions", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(9, x, y += 22, w, 20, "gui.game");
        button.setHoverText("data.hover.game", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(7, x, y += 22, w, 20, "gui.wipe");
        button.setHoverText("data.hover.wipe", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(12, x, y + 22, w, 20, "gui.cleaning");
        button.setHoverText("data.hover.cleaning", new Object[0]);
        this.addButton(button);
        y = this.guiTop + 170;
        this.addLabel(new GuiNpcLabel(1, "gui.found", this.guiLeft + 10, y + 5));
        GuiNpcTextField textField = new GuiNpcTextField(0, this, this.field_146289_q, this.guiLeft + 66, y, 240, 20, this.search);
        textField.setHoverText("data.hover.found", new Object[0]);
        this.addTextField(textField);
        x = this.guiLeft + 7;
        w = 73;
        button = new GuiNpcButton(8, x, y += 22, w, 20, "gui.add");
        button.setHoverText("hover.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(0, x += w + 3, y, w, 20, "gui.remove");
        button.setHoverText("hover.delete", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(10, x += w + 3, y, w, 20, "gui.remove.all");
        button.setHoverText("hover.delete.all", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(11, x + w + 3, y, w, 20, "selectServer.edit");
        button.setHoverText("hover.edit", new Object[0]);
        this.addButton(button);
        this.initButtons();
        if (this.selection == EnumPlayerData.Game) {
            y = this.guiTop + 18;
            this.addLabel(new GuiNpcLabel(2, "gui.money", this.guiLeft + 10, y + 5));
            textField = new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 66, y, 120, 20, "" + this.gameData.func_74763_f("Money"));
            textField.setMinMaxDefault(0L, Long.MAX_VALUE, this.gameData.func_74763_f("Money"));
            textField.setHoverText("data.hover.money", "9223372036854775807");
            this.addTextField(textField);
            GuiNpcLabel label = new GuiNpcLabel(3, new TextComponentTranslation("global.market", new Object[0]).func_150254_d() + ":", this.guiLeft + 10, y + 25);
            label.setHoverText("data.hover.markets", new Object[0]);
            this.addLabel(label);
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuGlobal);
            return;
        }
        super.func_73869_a(c, i);
        if (this.selection == EnumPlayerData.Wipe) {
            return;
        }
        if (this.search.equals(this.getTextField(0).getFullText())) {
            return;
        }
        this.search = this.getTextField(0).getFullText().toLowerCase();
        this.setCurrentList();
    }

    @Override
    public void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        if (k == 0 && this.scroll != null) {
            this.scroll.func_73864_a(i, j, k);
        }
    }

    @Override
    public void save() {
        ContainerNPCBank.editPlayerBankData = null;
        if (this.selection == EnumPlayerData.Game) {
            boolean hasPlayer;
            boolean bl = hasPlayer = this.selectedPlayer != null && !this.selectedPlayer.isEmpty();
            if (hasPlayer && this.gameData != null) {
                Client.sendData(EnumPacketServer.PlayerDataSet, this.selection.ordinal(), this.selectedPlayer, 0, this.gameData);
            }
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.selected = scroll.getSelected();
        if (this.selection == EnumPlayerData.Players) {
            this.selectedPlayer = this.selected;
            this.isOnline = this.data.get(this.selected) == 1;
        }
        this.initButtons();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        this.editData();
    }

    private void setCurrentList() {
        if (this.scroll == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> hovers = new ArrayList<String>();
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        if (this.selection == EnumPlayerData.Wipe) {
            this.selection = EnumPlayerData.Players;
        }
        switch (this.selection) {
            case Players: {
                ArrayList<String> listOn = new ArrayList<String>();
                ArrayList<String> listOff = new ArrayList<String>();
                for (String name : this.data.keySet()) {
                    if (!this.search.isEmpty() && !name.toLowerCase().contains(this.search)) continue;
                    if (this.data.get(name) == 1) {
                        listOn.add(name);
                        continue;
                    }
                    listOff.add(name);
                }
                Collections.sort(listOn);
                Collections.sort(listOff);
                list = listOn;
                list.addAll(listOff);
                for (String name : list) {
                    suffixes.add(new TextComponentTranslation(this.data.get(name) == 0 ? "gui.offline" : "gui.online", new Object[0]).func_150254_d());
                }
                break;
            }
            case Quest: {
                String key;
                TextComponentTranslation sfx;
                Object name;
                TreeMap mapA = new TreeMap();
                Iterator<String> mapF = new TreeMap();
                for (String str : this.data.keySet()) {
                    Object map;
                    String cat = str.substring(0, str.indexOf(": "));
                    name = str.substring(str.indexOf(": ") + 2);
                    if (((String)name).endsWith("(Active quest)")) {
                        name = ((String)name).substring(0, ((String)name).lastIndexOf("(Active quest)"));
                        map = mapA;
                    } else {
                        name = ((String)name).substring(0, ((String)name).lastIndexOf("(Finished quest)"));
                        map = mapF;
                    }
                    if (!map.containsKey(cat)) {
                        map.put(cat, new TreeMap());
                    }
                    ((Map)map.get(cat)).put(this.data.get(str), name);
                }
                for (Object cat : mapA.keySet()) {
                    sfx = new TextComponentTranslation("availability.active", new Object[0]);
                    sfx.func_150256_b().func_150238_a(TextFormatting.GREEN);
                    name = ((Map)mapA.get(cat)).keySet().iterator();
                    block14: while (name.hasNext()) {
                        int id = (Integer)name.next();
                        suffixes.add(sfx.func_150254_d());
                        key = "\u00a7aID:" + id + '\u00a7' + "7 " + (String)cat + ": \"" + '\u00a7' + "r" + (String)((Map)mapA.get(cat)).get(id) + '\u00a7' + "7\"";
                        list.add(key);
                        for (String str : this.data.keySet()) {
                            if (this.data.get(str) != id) continue;
                            this.scrollData.put(key, str);
                            continue block14;
                        }
                    }
                }
                for (Object cat : mapF.keySet()) {
                    sfx = new TextComponentTranslation("quest.complete", new Object[0]);
                    sfx.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
                    name = ((Map)mapF.get(cat)).keySet().iterator();
                    block17: while (name.hasNext()) {
                        int id = (Integer)name.next();
                        suffixes.add(sfx.func_150254_d());
                        key = "\u00a7dID:" + id + '\u00a7' + "7 " + (String)cat + ": \"" + '\u00a7' + "r" + (String)((Map)mapF.get(cat)).get(id) + '\u00a7' + "7\"";
                        list.add(key);
                        for (String str : this.data.keySet()) {
                            if (this.data.get(str) != id) continue;
                            this.scrollData.put(key, str);
                            continue block17;
                        }
                    }
                }
                break;
            }
            case Dialog: {
                Object map = new TreeMap();
                for (String str : this.data.keySet()) {
                    map.put(this.data.get(str), "\u00a77ID:" + this.data.get(str) + " " + str.replace(": ", ": \u00a7r"));
                }
                Iterator<String> mapF = map.keySet().iterator();
                block20: while (mapF.hasNext()) {
                    int id = (Integer)((Object)mapF.next());
                    list.add((String)map.get(id));
                    for (String str : this.data.keySet()) {
                        if (this.data.get(str) != id) continue;
                        this.scrollData.put((String)map.get(id), str);
                        continue block20;
                    }
                }
                break;
            }
            case Transport: {
                Object map = new TreeMap();
                for (String str : this.data.keySet()) {
                    map.put(this.data.get(str), "\u00a77" + str.replace(": ", ": \u00a7r"));
                }
                Iterator<String> mapF = map.keySet().iterator();
                block23: while (mapF.hasNext()) {
                    int id = (Integer)((Object)mapF.next());
                    list.add((String)map.get(id));
                    String catData = "cat null";
                    String locData = "loc null";
                    String pos = "pos null";
                    TransportLocation loc = TransportController.getInstance().getTransport(id);
                    if (loc != null) {
                        catData = "\u00a77" + new TextComponentTranslation("drop.category", new Object[0]).func_150254_d() + '\u00a7' + "7: \"" + '\u00a7' + "r" + new TextComponentTranslation(loc.category.title, new Object[0]).func_150254_d() + '\u00a7' + "7\" ID: " + '\u00a7' + "6" + loc.category.id;
                        locData = "\u00a77" + new TextComponentTranslation("gui.location", new Object[0]).func_150254_d() + '\u00a7' + "7: \"" + '\u00a7' + "r" + new TextComponentTranslation(loc.name, new Object[0]).func_150254_d() + '\u00a7' + "7\" ID: " + '\u00a7' + "6" + id;
                        pos = "\u00a77" + new TextComponentTranslation("parameter.world", new Object[0]).func_150254_d() + '\u00a7' + "7 ID: " + '\u00a7' + "a" + loc.dimension + '\u00a7' + "7; " + new TextComponentTranslation("parameter.position", new Object[0]).func_150254_d() + '\u00a7' + "7 X:" + '\u00a7' + "b" + loc.getX() + '\u00a7' + "7 Y:" + '\u00a7' + "b" + loc.getY() + '\u00a7' + "7 Z:" + '\u00a7' + "b" + loc.getZ();
                    }
                    hovers.add(catData + "<br>" + locData + "<br>" + pos);
                    for (String str : this.data.keySet()) {
                        if (this.data.get(str) != id) continue;
                        this.scrollData.put((String)map.get(id), str);
                        continue block23;
                    }
                }
                break;
            }
            case Bank: {
                for (String str : this.data.keySet()) {
                    list.add(str);
                    hovers.add("ID: " + this.data.get(str));
                    this.scrollData.put(str, str);
                }
                Collections.sort(list);
                break;
            }
            case Factions: {
                HashMap<String, String> mapH = new HashMap<String, String>();
                HashMap<String, Integer> mapC = new HashMap<String, Integer>();
                this.scrollData.clear();
                for (String str : this.data.keySet()) {
                    if (!this.search.isEmpty() && !str.toLowerCase().contains(this.search)) continue;
                    String[] l = str.split(";");
                    String key = new TextComponentTranslation(l[0], new Object[0]).func_150254_d() + '\u00a7' + "7 (ID:" + this.data.get(str) + ")";
                    list.add(key);
                    int value = -1;
                    try {
                        value = Integer.parseInt(l[1]);
                    }
                    catch (Exception e) {
                        LogWriter.error(e);
                    }
                    this.scrollData.put(key, str);
                    int color = 0xFFFFFF;
                    String hover = new TextComponentTranslation("type.value", new Object[0]).func_150254_d() + ": " + '\u00a7' + "3" + value;
                    Faction f = FactionController.instance.factions.get(this.data.get(str));
                    if (f != null) {
                        TextComponentTranslation add;
                        hover = hover + "<br>" + new TextComponentTranslation("gui.attitude", new Object[0]).func_150254_d() + ": ";
                        if (value < f.neutralPoints) {
                            add = new TextComponentTranslation("faction.unfriendly", new Object[0]);
                            add.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
                        } else if (value < f.friendlyPoints) {
                            add = new TextComponentTranslation("faction.neutral", new Object[0]);
                            add.func_150256_b().func_150238_a(TextFormatting.GOLD);
                        } else {
                            add = new TextComponentTranslation("faction.friendly", new Object[0]);
                            add.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
                        }
                        hover = hover + add.func_150254_d();
                        color = f.color;
                    }
                    mapH.put(key, hover);
                    mapC.put(key, color);
                }
                Collections.sort(list);
                for (String key : list) {
                    hovers.add((String)mapH.get(key));
                    colors.add((Integer)mapC.get(key));
                }
                break;
            }
            default: {
                return;
            }
        }
        this.scroll.setListNotSorted(list);
        this.scroll.setSuffixes(null);
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        if (!hovers.isEmpty()) {
            int i = 0;
            for (String str : hovers) {
                hts.put(i, Arrays.asList(str.split("<br>")));
                ++i;
            }
        }
        this.scroll.setHoverTexts(hts);
        if (!suffixes.isEmpty()) {
            this.scroll.setSuffixes(suffixes);
        }
        this.scroll.setColors(null);
        if (!colors.isEmpty()) {
            this.scroll.setColors(colors);
        }
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> dataMap) {
        if (this.selection == EnumPlayerData.Game) {
            return;
        }
        this.data.clear();
        this.data.putAll(dataMap);
        this.setCurrentList();
        if (this.selection == EnumPlayerData.Players && this.selectedPlayer != null) {
            this.scroll.setSelected(this.selectedPlayer);
            this.selected = this.selectedPlayer;
        }
        if (this.selection == EnumPlayerData.Wipe) {
            this.selection = EnumPlayerData.Players;
        }
        this.initButtons();
        if (ContainerNPCBank.editPlayerBankData != null) {
            this.buttonEvent(new GuiNpcButton(5, 0, 0, ""));
            ContainerNPCBank.editPlayerBankData = null;
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (this.selection != EnumPlayerData.Game || !compound.func_150297_b("GameData", 10)) {
            return;
        }
        this.gameData = compound;
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (int i = 0; i < compound.func_74775_l("GameData").func_150295_c("MarketData", 10).func_74745_c(); ++i) {
            NBTTagCompound nbt = compound.func_74775_l("GameData").func_150295_c("MarketData", 10).func_150305_b(i);
            map.put(nbt.func_74762_e("MarketID"), nbt.func_74762_e("Slot"));
        }
        ArrayList<String> list = new ArrayList<String>();
        MarcetController mData = MarcetController.getInstance();
        this.data.clear();
        int i = 0;
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            String key = "\u00a77ID:" + id + " " + new TextComponentTranslation("bank.slot", new Object[0]).func_150254_d() + '\u00a7' + "r: " + map.get(id);
            list.add(key);
            this.data.put(key, id);
            Marcet m = (Marcet)mData.getMarcet(id);
            ArrayList<String> hList = new ArrayList<String>();
            if (m != null) {
                hList.add("ID:" + id + " \"" + m.getName() + "\"");
                hList.add(new TextComponentTranslation("gui.max", new Object[0]).func_150254_d() + ": " + (m.markup.size() - 1));
            } else {
                hList.add(new TextComponentTranslation("global.market", new Object[0]).func_150254_d() + " - " + new TextComponentTranslation("quest.notfound", new Object[0]).func_150254_d());
            }
            hts.put(i, hList);
            ++i;
        }
        this.scroll.setListNotSorted(list);
        this.scroll.setHoverTexts(hts);
        this.func_73866_w_();
    }

    @Override
    public void setSelected(String selected) {
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiEditText) {
            if (subgui.getId() == 0) {
                try {
                    Client.sendData(EnumPacketServer.PlayerDataSet, this.selection.ordinal(), this.selectedPlayer, 0, Integer.parseInt(((SubGuiEditText)subgui).text[0]));
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            } else if (subgui.getId() == 1) {
                try {
                    Client.sendData(EnumPacketServer.PlayerDataSet, this.selection.ordinal(), this.selectedPlayer, 2, this.data.get(this.scrollData.get(this.scroll.getSelected())), Integer.parseInt(((SubGuiEditText)subgui).text[0]));
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            } else if (subgui.getId() == 2) {
                if (this.gameData == null || !this.data.containsKey(this.scroll.getSelected())) {
                    return;
                }
                int id = this.data.get(this.scroll.getSelected());
                for (int i = 0; i < this.gameData.func_74775_l("GameData").func_150295_c("MarketData", 10).func_74745_c(); ++i) {
                    NBTTagCompound nbt = this.gameData.func_74775_l("GameData").func_150295_c("MarketData", 10).func_150305_b(i);
                    if (id != nbt.func_74762_e("MarketID")) continue;
                    nbt.func_74768_a("Slot", subgui.getTextField(0).getInteger());
                    break;
                }
                this.setGuiData(this.gameData);
            }
            return;
        }
        if (subgui instanceof SubGuiDataSend) {
            Client.sendData(EnumPacketServer.PlayerDataCleaning, ((SubGuiDataSend)subgui).time);
        }
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.subgui != null && this.subgui instanceof SubGuiDataSend) {
            this.subgui.unFocused(textField);
            return;
        }
        if (textField.getID() != 1 || this.gameData == null || !textField.isLong()) {
            return;
        }
        this.gameData.func_74775_l("GameData").func_74772_a("Money", textField.getLong());
    }
}

